#include "Ship.h"

Ship::Ship()
{}

void Ship::Destroy()
{
	GameObject::Destroy();
}

void Ship::Init(ALLEGRO_BITMAP *image)
{
	GameObject::Init(0, 0, 0, 0, 0, 0, 3, 3);

	SetID(SHIP);
	SetAlive(true);

	health = 500;
	moving = false;
	speed = 1;
	attack = 1;
	range = 10;

	maxFrame = 3;
	curFrame = 0;
	frameWidth = 46;
	frameHeight = 41;
	animationColumns = 3;
	animationDirection = 1;

	animationRow = 1;
		
	BaseColor = al_map_rgb(255,255,255);

	if(image != NULL)
		Ship::image = image;
}


void Ship::Update()
{
	if(moving == true)
	{		
		float distance = sqrt((desty - GetY()) * (desty - GetY()) + (destx - GetX()) * (destx - GetX()));
		float velx = getSpeed() * (destx - GetX()) / distance;
		float vely = getSpeed() * (desty - GetY()) / distance;
							
		SetVelX(velx);
		SetVelY(vely);
	}
	x += velX;
	y += velY;

	if(x < 0)
		x = 0;
	else if(x > WIDTH)
		x = WIDTH;

	if(y < 0)
		y = 0;
	else if(y > HEIGHT)
		y = HEIGHT;
		
	if(x - destx < 10 && x - destx > -10 && y - desty < 10 && y - desty > -10)
	{
		Ship::SetVelX(0);
		Ship::SetVelY(0);
		setMoving(false);
	}
}

void Ship::Render()
{
	GameObject::Render();

	//====debugging options====//
	//al_draw_rectangle(x - boundX, y - boundY, x + boundX, y + boundY, BaseColor, 1);
	//al_draw_circle(x, y, range, al_map_rgb(50,50,50), 1);


	al_draw_circle(x, y, boundX, BaseColor, 1);
}


void Ship::Collided(int objectID, float velx, float vely)
{
	if(objectID == SHIP)
	{
		Ship::SetX(Ship::GetX() + velx);
		Ship::SetY(Ship::GetY() + vely);
	}
}

bool Ship::Attackble(Ship *otherShip)
{
	float oX = otherShip->GetX();
	float oY = otherShip->GetY();

	float dx = oX - GetX();
	float dy = oY - GetY();
	float radii = getRange() + otherShip->GetBoundX();


	if((dx * dx) + (dy * dy) < radii * radii)
		return true;
	else
		return false;
}